/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.crafting.sieve;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.registries.RegistryObject;
import novamachina.exnihilosequentia.common.crafting.ExNihiloRecipeSerializer;
import novamachina.exnihilosequentia.common.crafting.SerializableRecipe;
import novamachina.exnihilosequentia.common.crafting.sieve.MeshWithChance;
import novamachina.exnihilosequentia.common.item.mesh.MeshType;

public class SieveRecipe
extends SerializableRecipe {
    public static RecipeType<SieveRecipe> RECIPE_TYPE;
    @Nullable
    private static RegistryObject<ExNihiloRecipeSerializer<SieveRecipe>> serializer;
    @Nonnull
    private final ResourceLocation recipeId;
    @Nonnull
    private final List<MeshWithChance> rolls;
    @Nonnull
    private ItemStack drop;
    @Nonnull
    private Ingredient input;
    private boolean isWaterlogged;

    public SieveRecipe(@Nonnull ResourceLocation id, @Nonnull Ingredient input, @Nonnull ItemStack drop, @Nonnull List<MeshWithChance> rolls, boolean isWaterlogged) {
        super(drop, RECIPE_TYPE, id);
        this.recipeId = id;
        this.input = input;
        this.drop = drop;
        this.rolls = rolls;
        this.isWaterlogged = isWaterlogged;
    }

    @Nullable
    public static RegistryObject<ExNihiloRecipeSerializer<SieveRecipe>> getStaticSerializer() {
        return serializer;
    }

    public static void setSerializer(@Nonnull RegistryObject<ExNihiloRecipeSerializer<SieveRecipe>> serializer) {
        SieveRecipe.serializer = serializer;
    }

    public void addRoll(@Nonnull String meshString, float chance) {
        MeshType mesh = MeshType.valueOf(meshString.toUpperCase());
        this.addRoll(mesh, chance);
    }

    public void addRoll(@Nonnull MeshType mesh, float chance) {
        this.rolls.add(new MeshWithChance(mesh, chance));
    }

    @Nonnull
    public SieveRecipe filterByMesh(@Nonnull MeshType meshType, boolean flattenRecipes) {
        ArrayList<MeshWithChance> possibleMeshes = new ArrayList<MeshWithChance>();
        for (MeshWithChance mesh : this.rolls) {
            if (flattenRecipes) {
                if (mesh.getMesh().getLevel() > meshType.getLevel()) continue;
                possibleMeshes.add(mesh);
                continue;
            }
            if (mesh.getMesh().getLevel() != meshType.getLevel()) continue;
            possibleMeshes.add(mesh);
        }
        return new SieveRecipe(this.recipeId, this.input, this.drop, possibleMeshes, this.isWaterlogged);
    }

    @Nonnull
    public ItemStack getDrop() {
        return this.drop.m_41777_();
    }

    public void setDrop(@Nonnull ItemStack drop) {
        this.drop = drop;
    }

    @Nonnull
    public Ingredient getInput() {
        return this.input;
    }

    public void setInput(@Nonnull Ingredient input) {
        this.input = input;
    }

    @Nonnull
    public ResourceLocation getRecipeId() {
        return this.recipeId;
    }

    @Nonnull
    public ItemStack m_8043_() {
        return this.drop.m_41777_();
    }

    @Nonnull
    public List<MeshWithChance> getRolls() {
        return this.rolls;
    }

    public boolean isWaterlogged() {
        return this.isWaterlogged;
    }

    public void setWaterlogged() {
        this.isWaterlogged = true;
    }

    @Nonnull
    public String toString() {
        return "SieveRecipe{input=" + this.input + ", drop=" + this.drop + ", rolls=" + this.rolls + ", isWaterlogged=" + this.isWaterlogged + ", recipeId=" + this.recipeId + "}";
    }

    @Nullable
    protected ExNihiloRecipeSerializer<SieveRecipe> getENSerializer() {
        if (serializer == null) {
            return null;
        }
        return (ExNihiloRecipeSerializer)((Object)serializer.get());
    }
}

